/*
 * Decompiled with CFR 0.152.
 */
package CP.Game;

import CP.Blocks.Blocks;
import CP.Canvas.Canvas;
import CP.DefaultBlocks.DefaultBlocks;
import CP.DefaultMobs.DefaultMobs;
import CP.Drop.Drop;
import CP.GUI.GUI;
import CP.GUIInventory.GUIInventory;
import CP.Inventory.Inventory;
import CP.Keyboard.Keyboard;
import CP.Map.Map;
import CP.Mobs.Mobs;
import CP.Player.Player;
import CP.String.String;
import CP.System.System;

public final class Game {
    static int curx;
    static int cury;
    static boolean editmode;

    static void DrawGame() {
        int n = (int)Math.floor(Player.GetX() * 16.0) - (Canvas.GetWidth() >> 1);
        int n2 = (int)Math.floor(Player.GetY() * 16.0) - (Canvas.GetHeight() >> 1);
        int[] nArray = new int[1];
        n = Map.BlockCamera(n, n2, nArray);
        n2 = nArray[0];
        Canvas.SetColor(0, 0, 127);
        Canvas.FillRect(0, 0, Canvas.GetWidth(), Canvas.GetHeight());
        Map.DrawMap(n, n2);
        Mobs.Draw(n, n2);
        Drop.Draw(n, n2);
        if (editmode) {
            Canvas.SetColor(255, 255, 255);
            Canvas.FillRect(curx * 16 - n, cury * 16 - n2, 16, 16);
        }
        Inventory.DrawFastInventory(Player.GetInv());
        GUI.DrawWindows();
        Canvas.SetColor(255, 255, 255);
        Canvas.DrawText(String.IntToString(Canvas.GetFps()), 0, 0);
        Canvas.DrawText(String.RealToString(Player.GetX()), 0, 12);
        Canvas.DrawText(String.RealToString(Player.GetY()), 0, 24);
    }

    static void Std_KeyHandler() {
        if (Keyboard.KeyPressed(-1) || Keyboard.KeyPressed(50)) {
            Player.GoUp();
        }
        if (Keyboard.KeyPressed(-2) || Keyboard.KeyPressed(56)) {
            Player.GoDown();
        }
        if (Keyboard.KeyPressed(-3) || Keyboard.KeyPressed(52)) {
            Player.GoLeft();
        }
        if (Keyboard.KeyPressed(-4) || Keyboard.KeyPressed(54)) {
            Player.GoRight();
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Mobs.Create("PLAYER", Player.GetX(), Player.GetY());
        }
        if (Keyboard.KeyClicked(49)) {
            GUIInventory.OpenInventoryWindow();
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit(0);
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = true;
            curx = (int)Math.floor(Player.GetX());
            cury = (int)Math.floor(Player.GetY());
        }
    }

    static void Edit_KeyHandler() {
        if (Keyboard.KeyClicked(-1) || Keyboard.KeyClicked(50)) {
            --cury;
        }
        if (Keyboard.KeyClicked(-2) || Keyboard.KeyClicked(56)) {
            ++cury;
        }
        if (Keyboard.KeyClicked(-3) || Keyboard.KeyClicked(52)) {
            --curx;
        }
        if (Keyboard.KeyClicked(-4) || Keyboard.KeyClicked(54)) {
            ++curx;
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Blocks.InfoList[Map.Get(curx, cury)].Destroy(curx, cury);
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit(0);
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = false;
        }
    }

    static void KeyHandler() {
        if (GUI.HandleInput()) {
            if (editmode) {
                Game.Edit_KeyHandler();
            } else {
                Game.Std_KeyHandler();
            }
        }
        Keyboard.Update();
    }

    public static void Main() {
        Canvas.SetFullScreen(true);
        double d = 0.0;
        double d2 = (1024.0 - (double)Canvas.GetHeight() / 2.0) / 16.0;
        DefaultBlocks.Init();
        DefaultMobs.Init();
        Player.SetController(Mobs.CreateRET("PLAYER", d, d2));
        while (true) {
            Game.KeyHandler();
            Player.Do();
            Mobs.DoAi();
            Mobs.DoPhysics();
            Drop.DoPhysics();
            Game.DrawGame();
            Canvas.Repaint();
            Canvas.Delay(1);
        }
    }
}

